-- Copyright (c) 2010, Adam Crume
-- All rights reserved.
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions are met:
--
--     * Redistributions of source code must retain the above copyright notice,
--       this list of conditions and the following disclaimer.
--     * Redistributions in binary form must reproduce the above copyright
--       notice, this list of conditions and the following disclaimer in the
--       documentation and/or other materials provided with the distribution.
--     * Neither the name of the University of California nor the names of its
--       contributors may be used to endorse or promote products derived from
--       this software without specific prior written permission.
--
-- THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
-- AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
-- IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
-- ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
-- LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
-- CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
-- SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
-- INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
-- CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
-- ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
-- POSSIBILITY OF SUCH DAMAGE.


module Parseme where

-- Variables and constants take 0 time units
-- Functions take a time unit per argument plus the time for the body
-- Math operations take 3 time units (one for each argument, and one for computation)

-- Should get 7x + 1
-- f(x) = 1 + 3 + 3 + f(x - 1)
-- ax + b = 7 + ax - a + b
-- 0 = 7 - a
-- a = 7
-- f(0) = 1
-- b = 1
f :: Int -> Int
f 0 = 0
f x = 1 + f (x - 1)

-- Should be 5x + 2
f2 0 0 = 0
f2 x y = f2 (x-1) 0

-- Should be 5y + 2
f3 0 0 = 0
f3 x y = f3 0 (y-1)

-- Should be 5x + 5y + 2
f4 0 0 = 0
f4 0 y = f4 0 (y-1)
f4 x y = f4 (x-1) y

-- Should be 5/2*x^2 + 15/2*x + 5y + 2
f5 0 0 = 0
f5 x 0 = f5 (x-1) x
f5 x y = f5 x (y-1)

-- Should be 7x + 1
f6 x =
    case x of
      0 -> 0
      y -> 1 + f6 (y - 1)

-- Should be 4x + 1
f7 :: [Int] -> Int
f7 [] = 0
f7 (x:xs) = 1 + f7 xs

-- Should be 5/2*len(x)^2 + 15/2*len(x) + 5*len(y) + 2
f8 :: [Int] -> [Int] -> Int
f8 [] [] = 0
f8 (x:xs) [] = f8 xs (x:xs)
f8 (x:xs) (y:ys) = f8 (x:xs) ys

-- Should be 7x + 5
f9 :: Int -> Int
f9 x = 1 + f x
--f9 x = 1 + f2 0 x
