-- Copyright (c) 2010, Adam Crume
-- All rights reserved.
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions are met:
--
--     * Redistributions of source code must retain the above copyright notice,
--       this list of conditions and the following disclaimer.
--     * Redistributions in binary form must reproduce the above copyright
--       notice, this list of conditions and the following disclaimer in the
--       documentation and/or other materials provided with the distribution.
--     * Neither the name of the University of California nor the names of its
--       contributors may be used to endorse or promote products derived from
--       this software without specific prior written permission.
--
-- THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
-- AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
-- IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
-- ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
-- LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
-- CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
-- SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
-- INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
-- CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
-- ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
-- POSSIBILITY OF SUCH DAMAGE.


-- | Commonly used symbols expressed as constants to help catch typos at compile time.
module Ein.StandardSymbols where

import Ein.Data

blank = ESym "Blank"
compound = ESym "Compound"
count = ESym "Count"
equal = ESym "Equal"
false = ESym "False"
greater = ESym "Greater"
greaterOrEqual = ESym "GreaterOrEqual"
infinity = ESym "Infinity"
less = ESym "Less"
lessOrEqual = ESym "LessOrEqual"
list = ESym "List"
map = ESym "Map"
matchQ = ESym "MatchQ"
null = ESym "Null"
pattern = ESym "Pattern"
plus = ESym "Plus"
power = ESym "Power"
repeatedBlankNull = ESym "RepeatedBlankNull"
replace = ESym "Replace"
rule = ESym "Rule"
ruleDelayed = ESym "RuleDelayed"
sequence = ESym "Sequence"
set = ESym "Set"
setAttributes = ESym "SetAttributes"
setDelayed = ESym "SetDelayed"
switch = ESym "Switch"
symbol = ESym "Symbol"
times = ESym "Times"
true = ESym "True"
